#include <allegro.h>

#include "actor.h"
#include "sectors.h"
#include "draw.h"
#include "man.h"
#include "game.h"
#include "alienship.h"
#include "number.h"

ACTOR number_population[4];
ACTOR number_shield[3];
ACTOR number_ammo[4];

float number0_points[] = {
	    -8.000,     -2.000, // 0
	     2.000,     11.000, // 1
	     7.000,      0.000, // 2
	     0.000,    -10.000, // 3
	   -16.000,      0.000, // 4
	     1.000,     24.000, // 5
	    15.000,      1.000, // 6
	     0.000,    -20.000  // 7
};
int number0_lines[] = {
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	5, 6, 0, 0, 0,
	6, 7, 0, 0, 0,
	3, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0 
};
float number1_points[] = {
	    -2.000,    -18.000, // 0
	    -2.414,     19.657, // 1
	     4.828,     24.140, // 2
	     4.000,    -19.000, // 3
	    -1.724,    -18.278, // 4
	    -3.000,     19.000, // 5
	     5.000,     24.000, // 6
	     3.449,    -18.967  // 7
};
int number1_lines[] = {
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	5, 6, 0, 0, 0,
	6, 7, 0, 0, 0,
	3, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0 
};
float number2_points[] = {
	     7.000,     12.000, // 0
	    -9.000,     14.000, // 1
	    -9.000,     21.000, // 2
	    16.000,     16.000, // 3
	    17.000,     -5.000, // 4
	    -2.000,     -6.000, // 5
	   -15.000,    -11.000, // 6
	    16.000,    -14.000  // 7
};
int number2_lines[] = {
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	6, 7, 0, 0, 0,
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 5, 0, 0, 0,
	6, 0, 0, 0, 0 
};
float number3_points[] = {
	   -16.000,      4.000, // 0
	     1.000,     12.000, // 1
	    -9.000,     21.000, // 2
	    16.000,     16.000, // 3
	    13.000,     -7.000, // 4
	    -3.000,      3.000, // 5
	     0.000,     -4.000, // 6
	   -16.000,    -14.000  // 7
};
int number3_lines[] = {
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	6, 7, 0, 0, 0,
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 5, 0, 0, 0,
	6, 0, 0, 0, 0 
};
float number4_points[] = {
	   -15.000,     17.000, // 0
	    -4.000,      4.000, // 1
	     9.000,      3.000, // 2
	    16.000,     20.000, // 3
	     3.000,    -16.000, // 4
	    12.000,    -15.000, // 5
	    -9.000,     -1.000, // 6
	     7.000,     -3.000  // 7
};
int number4_lines[] = {
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	6, 7, 0, 0, 0,
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 5, 0, 0, 0,
	6, 0, 0, 0, 0 
};
float number5_points[] = {
	   -14.000,     12.000, // 0
	    15.000,     15.000, // 1
	    16.000,     10.000, // 2
	    -5.000,      6.000, // 3
	   -11.000,    -17.000, // 4
	    21.000,      0.000, // 5
	    -9.000,     -1.000, // 6
	     5.000,     -3.000  // 7
};
int number5_lines[] = {
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	6, 7, 0, 0, 0,
	0, 1, 0, 0, 0,
	1, 2, 0, 0, 0,
	2, 3, 0, 0, 0,
	3, 5, 0, 0, 0,
	6, 0, 0, 0, 0 
};
float number6_points[] = {
	    11.950,    -14.043, // 0
	   -12.000,    -14.000, // 1
	     4.000,     -6.000, // 2
	    -6.000,     -5.000, // 3
	    14.000,     11.000, // 4
	   -14.000,      4.000, // 5
	     9.046,     -0.421, // 6
	    -1.000,      1.000  // 7
};
int number6_lines[] = {
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	6, 7, 0, 0, 0,
	0, 1, 0, 0, 0,
	6, 0, 0, 0, 0,
	5, 1, 0, 0, 0,
	2, 3, 0, 0, 0 
};
float number7_points[] = {
	     5.518,      1.035, // 0
	     7.932,      6.208, // 1
	     4.138,    -16.898, // 2
	     0.345,    -15.864, // 3
	    17.000,     13.000, // 4
	   -16.209,     12.760, // 5
	     1.724,     -0.690, // 6
	     4.138,     -4.138  // 7
};
int number7_lines[] = {
	4, 5, 0, 0, 0,
	6, 7, 0, 0, 0,
	0, 1, 0, 0, 0,
	6, 0, 0, 0, 0,
	5, 1, 0, 0, 0,
	2, 3, 0, 0, 0,
	2, 4, 0, 0, 0,
	3, 7, 0, 0, 0 
};
float number8_points[] = {
	    -1.724,     -8.277, // 0
	     9.656,    -13.105, // 1
	    -8.277,    -12.070, // 2
	     7.242,     11.036, // 3
	    14.139,     15.519, // 4
	    -7.587,     15.174, // 5
	     4.138,     -8.966, // 6
	    -1.379,     10.346  // 7
};
int number8_lines[] = {
	4, 5, 0, 0, 0,
	6, 0, 0, 0, 0,
	5, 1, 0, 0, 0,
	2, 4, 0, 0, 0,
	3, 7, 0, 0, 0,
	1, 2, 0, 0, 0 
};
float number9_points[] = {
	     5.173,      3.104, // 0
	    -6.552,      5.518, // 1
	     6.897,    -10.691, // 2
	     7.932,     10.691, // 3
	    14.139,     15.519, // 4
	   -10.001,     15.864, // 5
	     2.069,    -10.346, // 6
	     2.759,     11.725  // 7
};
int number9_lines[] = {
	4, 5, 0, 0, 0,
	6, 0, 0, 0, 0,
	5, 1, 0, 0, 0,
	2, 4, 0, 0, 0,
	3, 7, 0, 0, 0,
	0, 1, 0, 0, 0,
	6, 2, 0, 0, 0 
};

void number_process(ACTOR *actor, int *num)
{
	int d;
	d = ((*num) / actor->type) % 10;
	if (actor->frame != d) {
		actor->anim++;	
		if (actor->anim == 16) {
			actor->anim = 0;	
			actor->frame++;
			if (actor->frame == 10) actor->frame = 0;
		}
	}
}

static void number_draw(ACTOR *actor, int x, int y)
{
	int c = 0;
	
	if (actor->timer == 0) c = 32 * 7;
	if (actor->timer == 1) c = 3;
	if (actor->timer == 2) c = 32 * 7 + 4 * 7;
	
	if (actor->frame == 0) c_draw_(x, y, points(number0), lines(number0), number0_points, number1_points, number0_lines, actor->anim / 16.0, c);
	if (actor->frame == 1) c_draw_(x, y, points(number1), lines(number1), number1_points, number2_points, number1_lines, actor->anim / 16.0, c);
	if (actor->frame == 2) c_draw_(x, y, points(number2), lines(number2), number2_points, number3_points, number2_lines, actor->anim / 16.0, c);
	if (actor->frame == 3) c_draw_(x, y, points(number3), lines(number3), number3_points, number4_points, number3_lines, actor->anim / 16.0, c);
	if (actor->frame == 4) c_draw_(x, y, points(number4), lines(number4), number4_points, number5_points, number4_lines, actor->anim / 16.0, c);
	if (actor->frame == 5) c_draw_(x, y, points(number5), lines(number5), number5_points, number6_points, number5_lines, actor->anim / 16.0, c);
	if (actor->frame == 6) c_draw_(x, y, points(number6), lines(number6), number6_points, number7_points, number6_lines, actor->anim / 16.0, c);
	if (actor->frame == 7) c_draw_(x, y, points(number7), lines(number7), number7_points, number8_points, number7_lines, actor->anim / 16.0, c);
	if (actor->frame == 8) c_draw_(x, y, points(number8), lines(number8), number8_points, number9_points, number8_lines, actor->anim / 16.0, c);
	if (actor->frame == 9) c_draw_(x, y, points(number9), lines(number9), number9_points, number0_points, number9_lines, actor->anim / 16.0, c);
}

static void num(ACTOR *actor, int w, int t)
{
	actor_init(actor);
	actor->type = t;
	bound_(points(number0), number0_points, &actor->l, &actor->t, &actor->r, &actor->b);
	actor->draw = number_draw;
	actor->timer = w;
}

void number_init(void) {
	num(&number_population[0], 0, 1000);
	num(&number_population[1], 0, 100);
	num(&number_population[2], 0, 10);
	num(&number_population[3], 0, 1);
	
	num(&number_shield[0], 1, 100);
	num(&number_shield[1], 1, 10);
	num(&number_shield[2], 1, 1);
	
	num(&number_ammo[0], 2, 1000);
	num(&number_ammo[1], 2, 100);
	num(&number_ammo[2], 2, 10);
	num(&number_ammo[3], 2, 1);
}
